#if !defined _PCW99_ODBC_Generic_H_
#define _PCW99_ODBC_Generic_H_

// include Benchmark Factory include files
#include "CSSBFC.h"
#include "CTimer.h"
#include "CSSBenchmark.h"
#include "BFC_ODBC.h"

// set to TRUE to add extra test mixes to the benchmark
#define _EXTRA_MIXES_ TRUE

// compatibility defines

// set to FALSE to not use views in queries
#define _USE_VIEWS_ TRUE
// set to FALSE to not use the 'distinct' keyword in queries
#define _USE_DISTINCT_ FALSE
// set to FALSE to not use outer joins in queries
#define _USE_OUTER_JOINS_ FALSE
// set to FALSE to not use positioned updates (i.e. update locks are not held in write queries)
#define _USE_POSITIONED_UPDATES_ FALSE

// define constants listing size of benchmark dataset in rows
#define RANDBASE		10000
#define RANDTWOMILL		20000
#define RANDTHREEMILL	30000
#define RANDFOURMILL	40000
#define RANDFIVEMILL	50000
#define RANDFOURRAM		200000

// declare and initialize constants
const SQLINTEGER NUM_ROWS = 1;								// fetch rows in 1 row blocks (needs to be 1 to avoid mysterious data truncation)

// define transaction class IDs
const int XID_OLTP_READ_SELECT = 1000;
const int XID_OLTP_READ_JOIN = 1100;
const int XID_OLTP_WRITE = 1200;
const int XID_DSS_SELECT = 1300;

// group names for transaction groups
enum
{
	OLTPReadSelect,
	OLTPReadJoin,
	OLTPWrite,
	DSSSelect
};

class AFX_EXT_CLASS PCW99_ODBC_Generic : public CSSBenchmark
{
	DECLARE_SERIAL(PCW99_ODBC_Generic)

public:

	PCW99_ODBC_Generic (void);
	~PCW99_ODBC_Generic (void);
	virtual BOOL RegisterTransactions(BOOL bRegisterObjectXact = FALSE);
};

// macros
#define CHECK_FOR_ERROR(HSTMT) \
	if (ReturnCode != SQL_SUCCESS) { \
		m_CTimer.SetEndTime (m_nUnits, m_nBytes); \
		pSQLDatabaseServer->HandleError(HSTMT); \
		if (HSTMT != NULL) SQLFreeHandle (SQL_HANDLE_STMT, HSTMT); \
		return FALSE; \
	}
#define CHECK_FOR_ERROR_EXECUTE(HSTMT) \
	if (ReturnCode != SQL_SUCCESS && ReturnCode != SQL_SUCCESS_WITH_INFO) { \
		m_CTimer.SetEndTime (m_nUnits, m_nBytes); \
		pSQLDatabaseServer->HandleError(HSTMT); \
		if (HSTMT != NULL) SQLFreeHandle (SQL_HANDLE_STMT, HSTMT); \
		return FALSE; \
	}
#define CHECK_FOR_ERROR_FETCH(HSTMT) \
	if (ReturnCode != SQL_SUCCESS && ReturnCode != SQL_NO_DATA) { \
		m_CTimer.SetEndTime (m_nUnits, m_nBytes); \
		pSQLDatabaseServer->HandleError(HSTMT); \
		if (HSTMT != NULL) SQLFreeHandle (SQL_HANDLE_STMT, HSTMT); \
		return FALSE; \
	}

#endif
